#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef CP437FONT8x8_H
#define CP437FONT8x8_H

static const uint8_t cp437font8x8[] PROGMEM = {
    0x0, 0x1, // size of one indicates fixed width no pixel pad font
    0x08, // width
    0x08, // height
    0x00, // first char
    0xff, // char count (note can't print character 0xff)
  0,   0,   0,   0,   0,   0,   0,   0, //''
126, 129, 149, 177, 177, 149, 129, 126, //''
126, 255, 235, 207, 207, 235, 255, 126, //''
 14,  31,  63, 126,  63,  31,  14,   0, //''
  8,  28,  62, 127,  62,  28,   8,   0, //''
 24, 186, 255, 255, 255, 186,  24,   0, //''
 16, 184, 252, 255, 252, 184,  16,   0, //''
  0,   0,  24,  60,  60,  24,   0,   0, //''
255, 255, 231, 195, 195, 231, 255, 255, //''
  0,  60, 102,  66,  66, 102,  60,   0, //'	'
255, 195, 153, 189, 189, 153, 195, 255, //''
112, 248, 136, 136, 253, 127,   7,  15, //''
  0,  78,  95, 241, 241,  95,  78,   0, //''
192, 224, 255, 127,   5,   5,   7,   7, //''
192, 255, 127,   5,   5, 101, 127,  63, //''
153,  90,  60, 231, 231,  60,  90, 153, //''
127,  62,  62,  28,  28,   8,   8,   0, //''
  8,   8,  28,  28,  62,  62, 127,   0, //''
  0,  36, 102, 255, 255, 102,  36,   0, //''
  0,  95,  95,   0,   0,  95,  95,   0, //''
  6,  15,   9, 127, 127,   1, 127, 127, //''
 64, 218, 191, 165, 253,  89,   3,   2, //''
  0, 112, 112, 112, 112, 112, 112,   0, //''
128, 148, 182, 255, 255, 182, 148, 128, //''
  0,   4,   6, 127, 127,   6,   4,   0, //''
  0,  16,  48, 127, 127,  48,  16,   0, //''
  8,   8,   8,  42,  62,  28,   8,   0, //'EOF'
  8,  28,  62,  42,   8,   8,   8,   0, //''
 60,  60,  32,  32,  32,  32,  32,   0, //''
  8,  28,  62,   8,   8,  62,  28,   8, //''
 48,  56,  60,  62,  62,  60,  56,  48, //''
  6,  14,  30,  62,  62,  30,  14,   6, //''
  0,   0,   0,   0,   0,   0,   0,   0, //' '
  0,   6,  95,  95,   6,   0,   0,   0, //'!'
  0,   7,   7,   0,   7,   7,   0,   0, //'"'
 20, 127, 127,  20, 127, 127,  20,   0, //'#'
 36,  46, 107, 107,  58,  18,   0,   0, //'$'
 70, 102,  48,  24,  12, 102,  98,   0, //'%'
 48, 122,  79,  93,  55, 122,  72,   0, //'&'
  4,   7,   3,   0,   0,   0,   0,   0, //'''
  0,  28,  62,  99,  65,   0,   0,   0, //'('
  0,  65,  99,  62,  28,   0,   0,   0, //')'
  8,  42,  62,  28,  28,  62,  42,   8, //'*'
  8,   8,  62,  62,   8,   8,   0,   0, //'+'
  0, 128, 224,  96,   0,   0,   0,   0, //','
  8,   8,   8,   8,   8,   8,   0,   0, //'-'
  0,   0,  96,  96,   0,   0,   0,   0, //'.'
 96,  48,  24,  12,   6,   3,   1,   0, //'/'
 62, 127, 113,  89,  77, 127,  62,   0, //'0'
 64,  66, 127, 127,  64,  64,   0,   0, //'1'
 98, 115,  89,  73, 111, 102,   0,   0, //'2'
 34,  99,  73,  73, 127,  54,   0,   0, //'3'
 24,  28,  22,  83, 127, 127,  80,   0, //'4'
 39, 103,  69,  69, 125,  57,   0,   0, //'5'
 60, 126,  75,  73, 121,  48,   0,   0, //'6'
  3,   3, 113, 121,  15,   7,   0,   0, //'7'
 54, 127,  73,  73, 127,  54,   0,   0, //'8'
  6,  79,  73, 105,  63,  30,   0,   0, //'9'
  0,   0, 102, 102,   0,   0,   0,   0, //':'
  0, 128, 230, 102,   0,   0,   0,   0, //';'
  8,  28,  54,  99,  65,   0,   0,   0, //'<'
 36,  36,  36,  36,  36,  36,   0,   0, //'='
  0,  65,  99,  54,  28,   8,   0,   0, //'>'
  2,   3,  81,  89,  15,   6,   0,   0, //'?'
 62, 127,  65,  93,  93,  31,  30,   0, //'@'
124, 126,  19,  19, 126, 124,   0,   0, //'A'
 65, 127, 127,  73,  73, 127,  54,   0, //'B'
 28,  62,  99,  65,  65,  99,  34,   0, //'C'
 65, 127, 127,  65,  99,  62,  28,   0, //'D'
 65, 127, 127,  73,  93,  65,  99,   0, //'E'
 65, 127, 127,  73,  29,   1,   3,   0, //'F'
 28,  62,  99,  65,  81, 115, 114,   0, //'G'
127, 127,   8,   8, 127, 127,   0,   0, //'H'
  0,  65, 127, 127,  65,   0,   0,   0, //'I'
 48, 112,  64,  65, 127,  63,   1,   0, //'J'
 65, 127, 127,   8,  28, 119,  99,   0, //'K'
 65, 127, 127,  65,  64,  96, 112,   0, //'L'
127, 127,  14,  28,  14, 127, 127,   0, //'M'
127, 127,   6,  12,  24, 127, 127,   0, //'N'
 28,  62,  99,  65,  99,  62,  28,   0, //'O'
 65, 127, 127,  73,   9,  15,   6,   0, //'P'
 30,  63,  33, 113, 127,  94,   0,   0, //'Q'
 65, 127, 127,   9,  25, 127, 102,   0, //'R'
 38, 111,  77,  89, 115,  50,   0,   0, //'S'
  3,  65, 127, 127,  65,   3,   0,   0, //'T'
127, 127,  64,  64, 127, 127,   0,   0, //'U'
 31,  63,  96,  96,  63,  31,   0,   0, //'V'
127, 127,  48,  24,  48, 127, 127,   0, //'W'
 67, 103,  60,  24,  60, 103,  67,   0, //'X'
  7,  79, 120, 120,  79,   7,   0,   0, //'Y'
 71,  99, 113,  89,  77, 103, 115,   0, //'Z'
  0, 127, 127,  65,  65,   0,   0,   0, //'['
  1,   3,   6,  12,  24,  48,  96,   0, //'\'
  0,  65,  65, 127, 127,   0,   0,   0, //']'
  8,  12,   6,   3,   6,  12,   8,   0, //'^'
128, 128, 128, 128, 128, 128, 128, 128, //'_'
  0,   0,   3,   7,   4,   0,   0,   0, //'`'
 32, 116,  84,  84,  60, 120,  64,   0, //'a'
 65, 127,  63,  72,  72, 120,  48,   0, //'b'
 56, 124,  68,  68, 108,  40,   0,   0, //'c'
 48, 120,  72,  73,  63, 127,  64,   0, //'d'
 56, 124,  84,  84,  92,  24,   0,   0, //'e'
 72, 126, 127,  73,   3,   2,   0,   0, //'f'
152, 188, 164, 164, 248, 124,   4,   0, //'g'
 65, 127, 127,   8,   4, 124, 120,   0, //'h'
  0,  68, 125, 125,  64,   0,   0,   0, //'i'
 96, 224, 128, 128, 253, 125,   0,   0, //'j'
 65, 127, 127,  16,  56, 108,  68,   0, //'k'
  0,  65, 127, 127,  64,   0,   0,   0, //'l'
124, 124,  24,  56,  28, 124, 120,   0, //'m'
124, 124,   4,   4, 124, 120,   0,   0, //'n'
 56, 124,  68,  68, 124,  56,   0,   0, //'o'
132, 252, 248, 164,  36,  60,  24,   0, //'p'
 24,  60,  36, 164, 248, 252, 132,   0, //'q'
 68, 124, 120,  76,   4,  28,  24,   0, //'r'
 72,  92,  84,  84, 116,  36,   0,   0, //'s'
  0,   4,  62, 127,  68,  36,   0,   0, //'t'
 60, 124,  64,  64,  60, 124,  64,   0, //'u'
 28,  60,  96,  96,  60,  28,   0,   0, //'v'
 60, 124, 112,  56, 112, 124,  60,   0, //'w'
 68, 108,  56,  16,  56, 108,  68,   0, //'x'
156, 188, 160, 160, 252, 124,   0,   0, //'y'
 76, 100, 116,  92,  76, 100,   0,   0, //'z'
  8,   8,  62, 119,  65,  65,   0,   0, //'{'
  0,   0,   0, 119, 119,   0,   0,   0, //'|'
 65,  65, 119,  62,   8,   8,   0,   0, //'}'
  2,   3,   1,   3,   2,   3,   1,   0, //'~'
112, 120,  76,  70,  76, 120, 112,   0, //''
 14, 159, 145, 177, 251,  74,   0,   0, //''
 58, 122,  64,  64, 122, 122,  64,   0, //''
 56, 124,  84,  85,  93,  25,   0,   0, //''
  2,  35, 117,  85,  85, 125, 123,  66, //''
 33, 117,  84,  84, 125, 121,  64,   0, //''
 33, 117,  85,  84, 124, 120,  64,   0, //''
 32, 116,  87,  87, 124, 120,  64,   0, //''
 24,  60, 164, 164, 228,  64,   0,   0, //''
  2,  59, 125,  85,  85,  93,  27,   2, //''
 57, 125,  84,  84,  93,  25,   0,   0, //''
 57, 125,  85,  84,  92,  24,   0,   0, //''
  1,  69, 124, 124,  65,   1,   0,   0, //''
  2,   3,  69, 125, 125,  67,   2,   0, //''
  1,  69, 125, 124,  64,   0,   0,   0, //''
121, 125,  22,  18,  22, 125, 121,   0, //''
112, 120,  43,  43, 120, 112,   0,   0, //''
 68, 124, 124,  85,  85,  69,   0,   0, //''
 32, 116,  84,  84, 124, 124,  84,  84, //''
124, 126,  11,   9, 127, 127,  73,   0, //''
 50, 123,  73,  73, 123,  50,   0,   0, //''
 50, 122,  72,  72, 122,  50,   0,   0, //''
 50, 122,  74,  72, 120,  48,   0,   0, //''
 58, 123,  65,  65, 123, 122,  64,   0, //''
 58, 122,  66,  64, 120, 120,  64,   0, //''
154, 186, 160, 160, 250, 122,   0,   0, //''
  1,  25,  60, 102, 102,  60,  25,   1, //''
 61, 125,  64,  64, 125,  61,   0,   0, //''
 24,  60,  36, 231, 231,  36,  36,   0, //''
104, 126, 127,  73,  67, 102,  32,   0, //''
 43,  47, 252, 252,  47,  43,   0,   0, //''
255, 255,   9,   9,  47, 246, 248, 160, //''
 64, 192, 136, 254, 127,   9,   3,   2, //''
 32, 116,  84,  85, 125, 121,  64,   0, //' '
  0,  68, 125, 125,  65,   0,   0,   0, //''
 48, 120,  72,  74, 122,  50,   0,   0, //''
 56, 120,  64,  66, 122, 122,  64,   0, //''
122, 122,  10,  10, 122, 112,   0,   0, //''
125, 125,  25,  49, 125, 125,   0,   0, //''
  0,  38,  47,  41,  47,  47,  40,   0, //''
  0,  38,  47,  41,  47,  38,   0,   0, //''
 48, 120,  77,  69,  96,  32,   0,   0, //''
 56,  56,   8,   8,   8,   8,   0,   0, //''
  8,   8,   8,   8,  56,  56,   0,   0, //''
 79, 111,  48,  24, 204, 238, 187, 145, //''
 79, 111,  48,  24, 108, 118, 251, 249, //''
  0,   0,   0, 123, 123,   0,   0,   0, //''
  8,  28,  54,  34,   8,  28,  54,  34, //''
 34,  54,  28,   8,  34,  54,  28,   8, //''
170,   0,  85,   0, 170,   0,  85,   0, //''
170,  85, 170,  85, 170,  85, 170,  85, //''
221, 255, 170, 119, 221, 170, 255, 119, //''
  0,   0,   0, 255, 255,   0,   0,   0, //''
 16,  16,  16, 255, 255,   0,   0,   0, //''
 20,  20,  20, 255, 255,   0,   0,   0, //''
 16,  16, 255, 255,   0, 255, 255,   0, //''
 16,  16, 240, 240,  16, 240, 240,   0, //''
 20,  20,  20, 252, 252,   0,   0,   0, //''
 20,  20, 247, 247,   0, 255, 255,   0, //''
  0,   0, 255, 255,   0, 255, 255,   0, //''
 20,  20, 244, 244,   4, 252, 252,   0, //''
 20,  20,  23,  23,  16,  31,  31,   0, //''
 16,  16,  31,  31,  16,  31,  31,   0, //''
 20,  20,  20,  31,  31,   0,   0,   0, //''
 16,  16,  16, 240, 240,   0,   0,   0, //''
  0,   0,   0,  31,  31,  16,  16,  16, //''
 16,  16,  16,  31,  31,  16,  16,  16, //''
 16,  16,  16, 240, 240,  16,  16,  16, //''
  0,   0,   0, 255, 255,  16,  16,  16, //''
 16,  16,  16,  16,  16,  16,  16,  16, //''
 16,  16,  16, 255, 255,  16,  16,  16, //''
  0,   0,   0, 255, 255,  20,  20,  20, //''
  0,   0, 255, 255,   0, 255, 255,  16, //''
  0,   0,  31,  31,  16,  23,  23,  20, //''
  0,   0, 252, 252,   4, 244, 244,  20, //''
 20,  20,  23,  23,  16,  23,  23,  20, //''
 20,  20, 244, 244,   4, 244, 244,  20, //''
  0,   0, 255, 255,   0, 247, 247,  20, //''
 20,  20,  20,  20,  20,  20,  20,  20, //''
 20,  20, 247, 247,   0, 247, 247,  20, //''
 20,  20,  20,  23,  23,  20,  20,  20, //''
 16,  16,  31,  31,  16,  31,  31,  16, //''
 20,  20,  20, 244, 244,  20,  20,  20, //''
 16,  16, 240, 240,  16, 240, 240,  16, //''
  0,   0,  31,  31,  16,  31,  31,  16, //''
  0,   0,   0,  31,  31,  20,  20,  20, //''
  0,   0,   0, 252, 252,  20,  20,  20, //''
  0,   0, 240, 240,  16, 240, 240,  16, //''
 16,  16, 255, 255,  16, 255, 255,  16, //''
 20,  20,  20, 255, 255,  20,  20,  20, //''
 16,  16,  16,  31,  31,   0,   0,   0, //''
  0,   0,   0, 240, 240,  16,  16,  16, //''
255, 255, 255, 255, 255, 255, 255, 255, //''
240, 240, 240, 240, 240, 240, 240, 240, //''
255, 255, 255, 255,   0,   0,   0,   0, //''
  0,   0,   0,   0, 255, 255, 255, 255, //''
 15,  15,  15,  15,  15,  15,  15,  15, //''
 56, 124,  68, 108,  56, 108,  68,   0, //''
252, 254,  42,  42,  62,  20,   0,   0, //''
126, 126,   2,   2,   6,   6,   0,   0, //''
  2, 126, 126,   2, 126, 126,   2,   0, //''
 99, 119,  93,  73,  99,  99,   0,   0, //''
 56, 124,  68, 124,  60,   4,   4,   0, //''
128, 254, 126,  32,  32,  62,  30,   0, //''
  4,   6,   2, 126, 124,   6,   2,   0, //''
153, 189, 231, 231, 189, 153,   0,   0, //''
 28,  62, 107,  73, 107,  62,  28,   0, //''
 76, 126, 115,   1, 115, 126,  76,   0, //''
 48, 120,  74,  79, 125,  57,   0,   0, //''
 24,  60,  36,  60,  60,  36,  60,  24, //''
152, 252, 100,  60,  62,  39,  61,  24, //''
 28,  62, 107,  73,  73,   0,   0,   0, //''
126, 127,   1,   1, 127, 126,   0,   0, //''
 42,  42,  42,  42,  42,  42,   0,   0, //''
 68,  68,  95,  95,  68,  68,   0,   0, //''
 64,  81,  91,  78,  68,  64,   0,   0, //''
 64,  68,  78,  91,  81,  64,   0,   0, //''
  0,   0,   0, 254, 255,   1,   7,   6, //''
 96, 224, 128, 255, 127,   0,   0,   0, //''
  8,   8, 107, 107,   8,   8,   0,   0, //''
 36,  54,  18,  54,  36,  54,  18,   0, //''
  0,   6,  15,   9,  15,   6,   0,   0, //''
  0,   0,   0,  24,  24,   0,   0,   0, //''
  0,   0,   0,  16,  16,   0,   0,   0, //''
 16,  48, 112, 192, 255, 255,   1,   1, //''
  0,  31,  31,   1,  31,  30,   0,   0, //''
  0,  25,  29,  23,  18,   0,   0,   0, //''
  0,   0,  60,  60,  60,  60,   0,   0, //''
  0,   0,   0,   0,   0,   0,   0,   0 //''
};

#endif

